package ibase.marketingCampaign;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

public class MailingListIC extends ValidatorEJB {

	E12GenericUtility genericUtility=new E12GenericUtility();
	
	@Override
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;

		try
		{

			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			// passing the dom to itemchanged method
			errString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
			System.out.println ("ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ("Exception :SfaTime :itemChanged(String,String):" + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
		}

		System.out.println ("returning from SfaTime itemChanged");
		return errString;
	}

	@Override
	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn,
			String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("Inside itemchange");
		//Document headerDom = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		StringBuffer valueXmlString = null;
		String name="";
		String email_id="";
		int currentFormNo = 0;
		ConnDriver connDriver = new ConnDriver();
		try
		{
		
			
			conn = getConnection();
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}

			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");

			switch(currentFormNo)

			{
			case 1:

				valueXmlString.append("<Detail1>");
				
				 if ("mail_list_type".equalsIgnoreCase(currentColumn.trim())) {
	                    String mailListType = checkNull(genericUtility.getColumnValue("mail_list_type", dom));

	                    // Check for 'S' or 'P'
	                    
	                    if ("S".equalsIgnoreCase(mailListType) || "D".equalsIgnoreCase(mailListType)) {
	                        valueXmlString.append("<sql_str protect='0'>").append("<![CDATA[]]>").append("</sql_str>\r\n");
	                    } else if ("P".equalsIgnoreCase(mailListType)) {
	                        valueXmlString.append("<sql_str protect='1'>").append("<![CDATA[]]>").append("</sql_str>\r\n");
	                    }
	                }
				 
				valueXmlString.append ("</Detail1>\r\n");
				break;
				
			case 2:
				
				System.out.println("In Case 2");
				valueXmlString.append("<Detail2>");
				String sql = checkNull(genericUtility.getColumnValue("sql_str", dom1));
				String type = checkNull(genericUtility.getColumnValue("mail_list_type", dom1));
				System.out.println(sql);
				System.out.println("Sql null checker");
				BaseLogger.log("3", null, null, "createProject >> XmlString :: [" + sql + "]");
				
				if ("itm_default".equalsIgnoreCase(currentColumn.trim())) {
					 if ("S".equalsIgnoreCase(type)) {
					String sqltest = sql;
					BaseLogger.log("3", null, null, "createProject >> XmlString :: [" + sqltest + "]");
					
				       String[] selectParts = sql.toLowerCase().split("from")[0].replace("select", "").trim().split(",");
				       String firstColumn = selectParts[0].trim();
				       String secondColumn = selectParts.length > 1 ? selectParts[1].trim() : "";
					
					try {
					pstmt = conn.prepareStatement(sqltest);
					rs = pstmt.executeQuery();
					if (rs.next()) {
						name = rs.getString(firstColumn);
						email_id =rs.getString(secondColumn);
					}
					valueXmlString.append("<name protect='1'><![CDATA[").append(name).append("]]></name>\r\n");
					valueXmlString.append("<email_id protect='1'><![CDATA[").append(email_id).append("]]></email_id>\r\n");
					}catch (SQLException e){
						BaseLogger.log("3", null, null, "createProject >> XmlString :: [" + "SQL Exception while executing query." + "]");
					}
				}
					 else if ("D".equalsIgnoreCase(type)) {
						 BaseLogger.log("3", null, null, "In dremio databse connection [" + sql + "]");

							//Connection code for Dremio Database
							
						        try {
						           
						         
						        	conn = connDriver.getConnectDB("APPVIS"+"_IN_MEM",true);
									BaseLogger.log("3", null, null, "Connected to Dremio!");


						           
						            Statement statement = conn.createStatement();
						            ResultSet resultSet = statement.executeQuery(sql);

						         
						            while (resultSet.next()) {
						                System.out.println(resultSet.getString(1)); 
						            }
						            resultSet.close();
						            statement.close();
						            conn.close();
						        }catch (SQLException se) {
							    	BaseLogger.log("3", null, null, "Exception in Dremio Connection [" + E12GenericUtility.getStackTrace(se) + "]");
						            throw new ITMException(se);
							    }
							
					
						}
					 
					}
				valueXmlString.append ("</Detail2>\r\n");
					break;
			}
			
				
			valueXmlString.append("</Root>\r\n");
		}
		catch(Exception e)
		{
			System.out.println("Exception :SfaTime :itemChanged(Document,String):" + e.getMessage() + ":");
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception :SfaTime :Exception in SQL" + e.getMessage() + ":");
				e.printStackTrace();
			}
		}
		return valueXmlString.toString();
	}
	
	
	// For validation 
	@Override
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		// Initially dom values are set to null

		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;

		// To check what is it printing

		System.out.println("xmlString["+xmlString+"]");
		System.out.println("xmlString1["+xmlString1+"]");
		System.out.println("xmlString2["+xmlString2+"]");

		// To validate weather the xml is not empty and neither null.

		try
		{

			if(xmlString != null && xmlString.trim().length()!=0)
			{
				// This satisfies both condition so we can convert this xml to dom.
				dom = genericUtility.parseString(xmlString);
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}

			// Here we call another method where we pass this newly created dom file.

			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);

			System.out.println("ErrString: " + errString);
		}
		catch(Exception e) // Catch any other exception
		{
			System.out.println("Exception: SfaTime: wfValData(String xmlString): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		System.out.println("Returning from SfaTime wfValData");

		// If there is no error we return the errString value which will come from consequetive method.
		return (errString);
	}
	
	
	@Override
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag,
			String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("Inside SfaTime validation");
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		Connection conn =null;
		String childNodeName = null;
		String errorString="";
		String userId="";
		int ctr=0;
		int currentFormNo=0;
		int childNodeListLength=0;
		
		try
		{
			conn = getConnection();
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
			if(objContext!=null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			parentNodeList = dom.getElementsByTagName("Detail" + currentFormNo);
			parentNode = parentNodeList.item(0);
			childNodeList = parentNode.getChildNodes();
			childNodeListLength = childNodeList.getLength();
			for(ctr = 0; ctr < childNodeListLength; ctr++)
			{
				childNode = childNodeList.item(ctr);
				childNodeName = childNode.getNodeName();
				switch(currentFormNo)
				{
				case 1:
					BaseLogger.log( "3", null, null, "In case 1 of validation" );
					 String mailListType = checkNull(genericUtility.getColumnValue("mail_list_type", dom));
					 BaseLogger.log( "3", null, null, "[below mailListType value : ("+ mailListType +") ]" );
					 if ("S".equalsIgnoreCase(mailListType)) {
							if(childNodeName.equalsIgnoreCase("sql_str"))
							{
								if(childNode.getFirstChild()==null)
								{
									errorString= getErrorString("sql_str","VTBISINTSQ",userId);
									break;
								}
					 }
					
				}
//					 String name = checkNull(genericUtility.getColumnValue("name", dom1));
//					 String Email =  checkNull(genericUtility.getColumnValue("email_id", dom1));
//					 BaseLogger.log( "3", null, null, "[ value from form 2 name : ("+ name +") ]" );
//					 BaseLogger.log( "3", null, null, "[ value from form 2 Email : ("+ Email +") ]" );
//					 
//					 if(name == null || name.length() == 0 ) {
//						 errorString= getErrorString("name","VTPRCNCP",userId);
//					 }else if(Email == null || Email.length() == 0 )
//					 {
//						 errorString= getErrorString("Email","VTPRCNCP",userId);
//					 }
					
			}
			}
		}catch(Exception e) {
			
		}		
		
		return errorString;
	}
	
	private String checkNull(String input)
	{
		if (input == null)
		{
			input = "";
		}
		else
		{
			input = input.trim();
		}
		return input;
	}
}
